#include <bits/stdc++.h>

using namespace std;

const int MAXN = 1024;

int parent[MAXN];
int s[MAXN];

int get_parent(int x) {
    if (parent[x] == x) return x;
    return parent[x] = get_parent(parent[x]);
}

bool same_set(int a, int b) {
    return get_parent(a) == get_parent(b);
}

int join(int a, int b) {
    int r1 = get_parent(a);
    int r2 = get_parent(b);
    if (r1 != r2) {
        int s1 = s[r1];
        int s2 = s[r2];
        if (s1 < s2) swap(r1, r2);
        parent[r2] = r1;
        s[r1] += s[r2];
    }
}
int main() {
#ifdef DRZAVNO
    freopen("../input.txt", "r", stdin);
    freopen("../output.txt", "w", stdout);
#endif // DRZAVNO
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    int n, q;
    cin >> n >> q;

    for (int i = 1; i <= n; i++) {
        s[i] = 1;
        parent[i] = i;
    }

    while (q--) {
        int t;
        cin >> t;
        if (t == 1) {
            int u, v;
            char c;
            cin >> u >> v >> c;
            join(u, v);
        }
        if (t == 2) {
            int u, v;
            cin >> u >> v;
            if (same_set(u, v)) {
                cout << 1 << '\n';
            }
            else {
                cout << 0 << '\n';
            }
        }
    }
    return 0;
}